/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-01-06
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ESACSTATISTICS_H
#define ESACSTATISTICS_H

#include <QGpCoreMath.h>
#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ESACStatistics
  {
  public:
    ESACStatistics();
    ~ESACStatistics();

    void setParameters(int nComponents);
    inline void addValue(Mode::Polarization polarization, double distance, double val);
    int count(int iComp) const {return _samples[iComp].count();}

    double leastSquareWaveNumber(double k0, int iComp);

    struct Attributes {
      double x, value, slope, concavity;
      int evaluationCount;
    };

    void setFunctionValue(Attributes& a) const;
    void setFunctionDerivatives(Attributes& a) const;
  private:
    int _nComp;
    VectorList<Point2D> * _samples;
    int _currentComponent;
    NewtonOptimization1D _opt;
  };

  inline void ESACStatistics::addValue(Mode::Polarization polarization, double distance, double val)
  {
    switch(polarization) {
    case Mode::Vertical:
      _samples[0].append(Point2D(distance, val));
      break;
    case Mode::Radial:
      _samples[1].append(Point2D(distance, val));
      break;
    case Mode::Transverse:
      _samples[2].append(Point2D(distance, val));
      break;
    case Mode::Rayleigh:
    case Mode::Love:
      ASSERT(false);
    }
  }

} // namespace ArrayCore

#endif // ESACSTATISTICS_H

