/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CrossSpectrumSplit.h"

namespace ArrayCore {

  /*!
    \class CrossSpectrumSplit CrossSpectrumSplit.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  CrossSpectrumSplit::CrossSpectrumSplit()
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  CrossSpectrumSplit::~CrossSpectrumSplit()
  {
    TRACE;
  }

  void CrossSpectrumSplit::addWaveNumber(const Vector<double>& k)
  {
    _kx.append(k[0]);
    _ky.append(k[1]);
  }

  void CrossSpectrumSplit::setMatrix(const ComplexMatrix& f)
  {
    size_t n3=f.rowCount();
    size_t n=n3/3;
    size_t n2=n+n;
    _fZZ.resize(n3);
    _fEE.resize(n3);
    _fEN.resize(n3);
    _fNE.resize(n3);
    _fNN.resize(n3);
    _fEZ.resize(n3);
    _fZE.resize(n3);

    _fEE.zero();
    _fEE.copySubMatrixAt(0, 0, f, 0, 0, n2, n2);
    _fEN.zero();
    _fEN.copySubMatrixAt(0, 0, f, 0, n, n, n, -1.0);
    _fEN.copySubMatrixAt(0, n, f, 0, 0, n, n);
    _fEN.copySubMatrixAt(n, 0, f, n, n, n, n, -1.0);
    _fEN.copySubMatrixAt(n, n, f, n, 0, n, n);
    _fNE.zero();
    _fNE.copySubMatrixAt(0, 0, f, n, 0, n, n, -1.0);
    _fNE.copySubMatrixAt(0, n, f, n, n, n, n, -1.0);
    _fNE.copySubMatrixAt(n, 0, f, 0, 0, n, n);
    _fNE.copySubMatrixAt(n, n, f, 0, n, n, n);
    _fNN.zero();
    _fNN.copySubMatrixAt(0, 0, f, n, n, n, n);
    _fNN.copySubMatrixAt(0, n, f, n, 0, n, n, -1.0);
    _fNN.copySubMatrixAt(n, 0, f, 0, n, n, n, -1.0);
    _fNN.copySubMatrixAt(n, n, f, 0, 0, n, n);
    _fEZ.zero();
    _fEZ.copySubMatrixAt(0, n2, f, 0, n2, n, n);
    _fEZ.copySubMatrixAt(n, n2, f, n, n2, n, n);
    _fZE.zero();
    _fZE.copySubMatrixAt(0, n2, f, n, n2, n, n, -1.0);
    _fZE.copySubMatrixAt(n, n2, f, 0, n2, n, n);
    _fZZ.zero();
    _fZZ.copySubMatrixAt(n2, n2, f, n2, n2, n, n);
  }

} // namespace ArrayCore

