/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-10
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ASYNCARRAYPROCESS_H
#define ASYNCARRAYPROCESS_H

#include "ArrayCoreDLLExport.h"
#include "FKCrossSpectrum.h"
#include "AsyncParameters.h"
#include "AsyncStationPair.h"

namespace ArrayCore {
#if 0
  class ARRAYCORE_EXPORT AsyncArrayProcess : public FKCrossSpectrum
  {
  public:
    AsyncArrayProcess(const ArraySelection * array);
    ~AsyncArrayProcess();

    ArrayStations::Mode mode() const {return _mode;}

    bool setParameters(const ArrayParameters * param);
    inline const AsyncParameters * parameters() const;

    void crossSpectrum();
  private:
    void setReferenceStation();
    void setTimeRanges();
    void setTimeRangeList(const AsyncStationPair& stations);
    void crossSpectrum(AsyncStationPair& stations);
    bool lockTimeWindow(const TimeRange &win, const AsyncStationPair& stations);
    void unlockTimeWindow(const AsyncStationPair& stations);

    ArrayStations::Mode _mode;
    int _verticalIndex, _northIndex, _eastIndex;
    TimeRange _globalRange;
    int _referenceStationIndex;
    ArrayStationSignals * _referenceStation;
    SparseTimeRange * _timeRanges;
    TimeRangeList _timeRangeList;
    VectorList<AsyncStationPair *> _couples;
  };

  inline const AsyncParameters * AsyncArrayProcess::parameters() const
  {
    return static_cast<const AsyncParameters *>(ArrayCrossSpectrum::parameters());
  }
#endif
} // namespace ArrayCore

#endif // ASYNCARRAYPROCESS_H

