/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-11-29
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ArrayTask.h"
#include "ArrayTaskManager.h"

namespace ArrayCore {

  /*!
    \class ArrayTask ArrayTask.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ArrayTask::ArrayTask(ArrayTaskManager * manager,
                       int taskIndex,
                       const ArraySelection * array,
                       const SparseKeepSignal * keep,
                       const ArrayParameters * param)
    : ParallelTask(manager, taskIndex),
      _timeWindows(array, keep, param)
  {
    TRACE;
    // Process from high to low frequencies
    _timeWindows.setFrequencyIndex(param->frequencySampling().count()-taskIndex-1);
    emit statusChanged(taskIndex, _timeWindows.toString(taskIndex));
  }

  /*!
    Description of destructor still missing
  */
  ArrayTask::~ArrayTask()
  {
    TRACE;
  }

  void ArrayTask::init()
  {
    _timeWindows.setWindows();
    setStepCount(_timeWindows.list().count());
    QString status=_timeWindows.toString(taskIndex());
    App::log(status+"\n");
    emit statusChanged(taskIndex(), status);
    ParallelTask::init();
  }

} // namespace ArrayCore

