/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-09
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveFKTaskManager.h"
#include "ActiveFKWorker.h"
#include "ActiveFKTask.h"

namespace ArrayCore {

  /*!
    \class ActiveFKTaskManager ActiveFKTaskManager.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ActiveFKTaskManager::ActiveFKTaskManager(const ArraySelection * array,
                                           const SeismicEvent * src,
                                           IrregularGrid2D * grid)
    : FKTaskManager(array)
  {
    TRACE;
    _source=src;
    _grid=grid;
  }

  /*!
    Description of destructor still missing
  */
  ActiveFKTaskManager::~ActiveFKTaskManager()
  {
    TRACE;
  }

  bool ActiveFKTaskManager::setParameters(const ArrayParameters * param)
  {
    TRACE;
    const ActiveFKParameters * fkParam=dynamic_cast<const ActiveFKParameters *>(param);
    if(!fkParam) {
      qDebug() << "Parameters are not ActiveFKParameters in ActiveFKTaskManager::setParameters.";
      return false;
    }
    if(!FKTaskManager::setParameters(param)) {
      return false;
    }
    // Set source here?

    setTasks();
    return true;
  }

  LoopWorker * ActiveFKTaskManager::newWorker()
  {
    TRACE;
    ActiveFKWorker * w=new ActiveFKWorker(&_array, parameters(), _source, _grid);
    w->setTaskManager(this);
    if(w->setGrid(_gridCache)) {
      return w;
    } else {
      delete w;
      return nullptr;
    }
  }

  ParallelTask * ActiveFKTaskManager::createTask(int taskIndex)
  {
    TRACE;
    return new ActiveFKTask(this, taskIndex, &_array, _keep, _parameters, _source);
  }

} // namespace ArrayCore

