/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-03-27
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKPARAMETERS_H
#define ACTIVEFKPARAMETERS_H

#include <GeopsyCore.h>

#include "FKParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveFKParameters: public FKParameters
  {
  public:
    ActiveFKParameters();

    AbstractParameters * clone() const {return new ActiveFKParameters(*this);}

    enum BeamPowerNormalization {Raw, Spectrum, Maximum};

    SamplingParameters& ySampling() {return _ySampling;}
    const SamplingParameters& ySampling() const {return _ySampling;}
    void setYSampling(const SamplingParameters& y) {_ySampling=y;}

    BeamPowerNormalization beamPowerNormalization() const {return _beamPowerNormalization;}
    QString beamPowerNormalizationString() const;
    void setBeamPowerNormalization(const BeamPowerNormalization& b) {_beamPowerNormalization=b;}
    void setBeamPowerNormalization(const QString& b);

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void setVersion(PARAMETERS_SETVERSION_ARGS);
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    int totalKeywordCount(PARAMETERS_TOTALKEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    BeamPowerNormalization _beamPowerNormalization;
    SamplingParameters _ySampling;
  };

} // namespace ArrayCore

#endif // ACTIVEFKPARAMETERS_H
