/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-22
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVECONVFKRAYLEIGH_H
#define ACTIVECONVFKRAYLEIGH_H

#include "AbstractFKRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveConvFKRayleigh : public AbstractFKRayleigh
  {
  public:
    ActiveConvFKRayleigh(FKCache * cache);
    ~ActiveConvFKRayleigh();

    void initialize(const FKParameters& param);
    FunctionSearch * createSearch(const FKParameters& param);
    bool setSource(const VectorList<int>& blocks);

    void resetCrossSpectrum();
    void addCrossSpectrum();
    void meanCrossSpectrum(int nBlocks);
    void addIncoherentNoise(double horizontal, double vertical);

    void shareSteering(const ActiveConvFKRayleigh * s);
    void clearSharedSteering();

    FK_ACTIVE_STEERING
  };

} // namespace ArrayCore

#endif // ACTIVECONVFKRAYLEIGH_H

