/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-04
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTELLIPTICITYENGINE_H
#define ABSTRACTELLIPTICITYENGINE_H

#include "ArrayCoreDLLExport.h"
#include "FKParameters.h"
#include "ConvFKVertical.h"
#include "AbstractFKRayleigh.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT AbstractEllipticityEngine
  {
  public:
    AbstractEllipticityEngine(const FKParameters& param);
    virtual ~AbstractEllipticityEngine();

    double ellipticity() const {return _xi;}
    double verticalNoise() const {return _RzOverN;}
    double radialNoise() const {return _RhOverN;}

    virtual double radialPower(Vector<double>& kell,
                               FKCrossSpectrum * crossSpectrum)=0;
    virtual double radialWavenumberNormalizedConcavity(Vector<double>& kell)=0;
    virtual double radialConcavity(Vector<double>& kell, int axis)=0;
    virtual double verticalPower(Vector<double>& kell,
                                 FKCrossSpectrum * crossSpectrum)=0;
    virtual double verticalWavenumberNormalizedConcavity(Vector<double>& kell)=0;
    virtual double verticalConcavity(Vector<double>& kell, int axis)=0;
  protected:
    ConvFKVertical * _vertical;
    ConvFKVertical * _radial;

    GridSearch2D _grid;
    double _kmin, _gridStep;
    double _xi, _RzOverN, _RhOverN;
  };

} // namespace ArrayCore

#endif // ABSTRACTELLIPTICITYENGINE_H

