/***************************************************************************
**
**  This file is part of spac2disp.
**
**  spac2disp is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  spac2disp is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-11-12
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef READER_H
#define READER_H

#include <QGpCoreStat.h>
#include <ArrayCore.h>

#include "Samples.h"

class Reader : public HistogramReader
{
public:
  Reader();
  ~Reader();

  bool setOptions(int& argc, char ** argv);

  void setMinimumVelocity(double v) {_sMax=1.0/v;}
  void setMaximumVelocity(double v) {_sMin=1.0/v;}

  void setSamples(Samples * s) {_samples=s;}
  Samples * samples() {return _samples;}
  bool isEmpty() const {return _samples->isEmpty();}

  bool strictFrequencyRange() const {return _strict;}
  bool setFrequencyRange(const AutocorrCurves& curves);

  int convert();

  static void help(ApplicationHelp * h);
protected:
  bool parse(QTextStream& s);
  bool loadSamples(QTextStream& s, const QString& lastLine);
private:
  Samples * _samples;
  QString _outputFileName;
  double _sMin, _sMax;
  bool _strict;
  SPACParameters _parameters;

  VectorList<double> _maxFrequencies;
};

#endif // READER_H

