/***************************************************************************
**
**  This file is part of phaseit.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-09
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PLUGIN_H
#define PLUGIN_H

#include <GeopsyGui.h>

class Plugin : public GeopsyGuiInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.geopsyInterface")
#endif
  Q_INTERFACES(GeopsyCore::GeopsyCoreInterface)
public:
  QString tag() const {return "phaseit";}
  QString title() const {return tr("Phase shift measurements");}

  void createToolActions(QObject * toolFactory);
  AbstractToolWidget * createTool(int id, QWidget * wsParent) const;

  const char * interfaceVersion() const;
};

#endif // PLUGIN_H
