/***************************************************************************
**
**  This file is part of phaseit.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-09
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDRESULTS_H
#define GRIDRESULTS_H

#include <SciFigs.h>

#include "TaskManager.h"

class GridResults : public GraphicSheetMenu
{
  Q_OBJECT
public:
  GridResults(QWidget * parent=nullptr);
  ~GridResults();

  void setResultCount(int n);
  void setName(int ig, const QString& name);
  void setTimeReference(int ig, const DateTime& t);
  void setValues(const TaskManager * tm);
  void setLayout(double pageHeight);
private:
  void setAxis(AxisWindow * w);

  int _resultCount;
  ColorMapWidget * _colorMapCoherence;
  ColorMapWidget * _colorMapPhase;
  ColorMapWidget * _colorMapAmplitude;
  TextEdit ** _comments;
  IrregularGrid2DPlot ** _coherence;
  IrregularGrid2DPlot ** _phase;
  IrregularGrid2DPlot ** _amplitude;
};

#endif // GRIDRESULTS_H
