/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-01-16
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAXENTRY_H
#define MAXENTRY_H

#include <QtCore>

class MaxEntry
{
public:
  MaxEntry() {_selected=true;}
  virtual ~MaxEntry() {}

  virtual bool readLine(QTextStream& s)=0;
  virtual void writeHeader(QTextStream& s) const=0;
  virtual void writeLine(QTextStream& s) const=0;

  virtual bool operator<(const MaxEntry& o) const;

  bool isSelected() const {return _selected;}
  void setSelected(bool s) {_selected=s;}

  double x() const {return _x;}
  double time() const {return _time;}

  virtual double value() const=0;
protected:
  bool _selected;
  double _time;
  double _x;
};

#endif // MAXENTRY_H
