/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-15
**  Authors:
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PLUGIN_H
#define PLUGIN_H

#include <GeopsyGui.h>

class Plugin : public GeopsyCoreInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.geopsyInterface")
#endif
  Q_INTERFACES(GeopsyCore::GeopsyCoreInterface)
public:
  Plugin();

  QString tag() const {return "matfiles";}
  QString title() const {return tr("Mat-file support");}
  QString description() const {return tr("Import/export of signals through Mat-files (Matlab)");}

  const char * interfaceVersion() const;
};

#endif // PLUGIN_H
