/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#include "HVTFAPlugin.h"
#include "ToolHVTFA.h"

#include "hvtfaInstallPath.h"
#include "hvtfaVersion.h"
#include "GeopsyCoreVersion.h"

/*!
  \class HVTFAPlugin HVTFAPlugin.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const char * HVTFAPlugin::interfaceVersion() const
{
  return GEOPSYCORE_VERSION;
}

void HVTFAPlugin::createToolActions(QObject * toolFactory)
{
  TRACE;
  QAction * a;

  a=new QAction(toolFactory);
  a->setText(tr("H/V TFA"));
  a->setIcon(QIcon(":hvtfa-22x22.png"));
  a->setStatusTip(tr("Rayleigh ellipticity based on Morlet wavelet."));
  connect(a, SIGNAL(triggered()), toolFactory, SLOT(showTool()) );
  addAction(a);
}

AbstractToolWidget * HVTFAPlugin::createTool(int id, QWidget * wsParent) const
{
  TRACE;
  switch (id) {
  case 0:
    return new ToolHVTFA(wsParent);
    break;
  default:
    break;
  }
  return 0;
}

PACKAGE_INFO("hvtfa", HVTFA)
#if(QT_VERSION < QT_VERSION_CHECK(5, 0, 0))
Q_EXPORT_PLUGIN2(hvtfa, HVTFAPlugin)
#endif
