/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreMath.h>

#include "Sample.h"

/*!
  \class Sample Sample.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

Sample::Sample()
{
  _frequency=0.0;
  _slowness=0.0;
  _azimuth=0.0;
  _ellipticity=0.0;
  _verticalNoise=0.0;
  _horizontalNoise=0.0;
  _power=0.0;
}

/*!
  Read and parse next available not blank and not starting with '#',
  and containing \a pattern. Non-valid samples are ignored.
*/
bool Sample::read(const QString& line, int timeColumn, int freqColumn,
                  int slowColumn, int azimuthColumn, int ellColumn,
                  int verticalNoiseColumn, int horizontalNoiseColumn,
                  int powerColumn, int validColumn)
{
  TRACE;
  bool ok=true;
  LineParser lp(line);
  _time=lp.toString(timeColumn, ok);
  _frequency=lp.toDouble(freqColumn, ok);
  _slowness=lp.toDouble(slowColumn, ok);
  _azimuth=lp.toDouble(azimuthColumn, ok);
  _ellipticity=lp.toDouble(ellColumn, ok);
  _verticalNoise=lp.toDouble(verticalNoiseColumn, ok);
  _horizontalNoise=lp.toDouble(horizontalNoiseColumn, ok);
  _power=lp.toDouble(powerColumn, ok);
  bool valid=(lp.toInt(validColumn, ok)==1);
  _line=line;
  if(ok) {
    return valid;
  } else {
    App::log(tr("Error parsing line '%1'\n").arg(line));
    return false;
  }
}

void Sample::writeValues(QTextStream& s) const
{
  TRACE;
  s <<  _time << " " << _frequency << " "
     << _slowness << " "
     << _azimuth << " "
     << _ellipticity << " "
     << _verticalNoise << " "
     << _horizontalNoise << " "
     << _power << " 1\n";
}

double Sample::xixDeviation() const
{
  double xir=Angle::degreesToRadians(_ellipticity);
  double xix=0.5*atan2(sin(2.0*xir), cos(2.0*xir)+_verticalNoise-_horizontalNoise);
  return Angle::radiansToDegrees(fabs(xix)-fabs(xir));
}

double Sample::xisDeviation() const
{
  double xir=Angle::degreesToRadians(_ellipticity);
  double xis=sqrt((sin(xir)+_horizontalNoise)/(cos(xir)+_verticalNoise));
  return Angle::radiansToDegrees(xis-fabs(xir));
}


