/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-25
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HORIZONTALNOISEPROXY_H
#define HORIZONTALNOISEPROXY_H

#include <QGpCoreMath.h>

class HorizontalNoiseProxy : public FrequencyCurveProxy
{
  TRANSLATIONS("HorizontalNoiseProxy")
public:
  QString tag() const {return "HorizontalNoiseProxy";}

  CurveProxy * clone() const {return new HorizontalNoiseProxy;}

  QString columnName(int col) const;
  QStringList columnFileTypes() const;
};

#endif // HORIZONTALNOISEPROXY_H

