/***************************************************************************
**
**  This file is part of gpprofile.
**
**  gpprofile is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpprofile is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROFILEREADER_H
#define PROFILEREADER_H

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

class ProfileReader : public ArgumentStdinReader
{
  TRANSLATIONS("ProfileReader")
public:
  ProfileReader();
  ~ProfileReader();

  bool setOptions(int& argc, char ** argv);
  bool terminate();
protected:
  virtual bool parse(QTextStream& s);
private:
  enum ModelType {SurfaceWaveModels, RefractionModels, ResistivityModels};
  enum ProfileType {Vp, Vs, Rho, Poisson, Impedance, Resistivity, Model};
  enum Output {Original, Resample, MinMax, AverageProfiles, StddevProfiles, AverageDepths, At, AverageAt, Pseudo3D};

  bool parseSurfaceWaveModels(QTextStream& s);
  bool parseResistivityModels(QTextStream& s);

  Profile profile(const Seismic1DModel& m) const;
  Profile profile(const Resistivity1DModel& m) const;
  void profileComment(QTextStream& sOut, const QString& comments) const;

  ModelType _model;
  ProfileType _profile;
  Output _output;
  double _maxDepth;
  int _nDepths;
  int _nProfiles;

  VectorList<double> _sampling;
  Curve<Point2D> _vMin, _vMax;

  Point _pseudo3DAt;
  Point * _pseudo3DPositions;
  Seismic1DModel * _pseudo3DModels;
};

#endif // PROFILEREADER_H
