/***************************************************************************
**
**  This file is part of gpmaplayer.
**
**  gpmaplayer is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmaplayer is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-03-27
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGEMERGER_H
#define IMAGEMERGER_H

#include <GeopsyCore.h>

class ImageMerger
{
public:
  ImageMerger();
  ~ImageMerger();

  static void setFilterFrequency(double f) {_filterFrequency=f;}
  static void setDefaultXStep(double s) {_defaultSteps.setX(s);}
  static void setDefaultYStep(double s) {_defaultSteps.setY(s);}
  static void setXStep(double s) {_forcedSteps.setX(s);}
  static void setYStep(double s) {_forcedSteps.setY(s);}
  static void addGoodXStep(double s) {_steps[0].add(s);}
  static void addGoodYStep(double s) {_steps[1].add(s);}
  static double defaultYStep();
  static double defaultXStep();
  static double forcedXStep() {return _forcedSteps.x();}
  static double forcedYStep() {return _forcedSteps.y();}
  static void printAverageSteps();
  static bool isDebugMode() {return _debugMode;}
  static void setDebugMode(bool m) {_debugMode=m;}
protected:
  static DoubleSignal * preprocess(DoubleSignal * s);
  static void exportDebugSignals(DoubleSignal * newVector, DoubleSignal * mainVector, DoubleSignal * corr);

  static double _filterFrequency;
  static Statistics _steps[2];
  static Point2D _defaultSteps;
  static Point2D _forcedSteps;
  static bool _debugMode;
};

#endif // IMAGEMERGER_H
