/***************************************************************************
**
**  This file is part of gpmaplayer.
**
**  gpmaplayer is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmaplayer is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-03-27
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ImageMerger.h"

/*!
  \class ImageMerger ImageMerger.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

double ImageMerger::_filterFrequency=0.005;
Point2D ImageMerger::_defaultSteps;
Point2D ImageMerger::_forcedSteps;
Statistics ImageMerger::_steps[2];
bool ImageMerger::_debugMode=false;

/*!
  Description of constructor still missing
*/
ImageMerger::ImageMerger()
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
ImageMerger::~ImageMerger()
{
  TRACE;
}

double ImageMerger::defaultXStep()
{
  if(_steps[0].count()>5) {
    return _steps[0].mean();
  } else {
    return _defaultSteps.x();
  }
}

double ImageMerger::defaultYStep()
{
  if(_steps[1].count()>5) {
    return _steps[1].mean();
  } else {
    return _defaultSteps.y();
  }
}

void ImageMerger::printAverageSteps()
{
  TRACE;
  App::log(tr("Average pixel steps %1, %2\n").arg(qRound(_steps[0].mean())).arg(qRound(_steps[1].mean())));
}

DoubleSignal * ImageMerger::preprocess(DoubleSignal * s)
{
  TRACE;
  s->removeTrend();
  FilterParameters fparam;
  fparam.setBand(FilterParameters::HighPass);
  fparam.setMethod(FilterParameters::FrequencyWindow);
  fparam.setFrequencyRange(_filterFrequency);
  fparam.setWidth(0.1);
  fparam.frequencyWindow().setShape(WindowFunctionParameters::Cosine);
  s->filter(fparam);
  // Remove border effects
  DoubleSignal * sCut=new DoubleSignal(s->nSamples()-100);
  sCut->setSamplingPeriod(1.0);
  sCut->copySamplesFrom(s, 50, 0, s->nSamples()-100);
  return sCut;
}

void ImageMerger::exportDebugSignals(DoubleSignal * newVector, DoubleSignal * mainVector, DoubleSignal * corr)
{
  TRACE;
  Signal * tmp1=new Signal(GeopsyCoreEngine::instance()->defaultDatabase());
  tmp1->setNSamples(newVector->nSamples());
  tmp1->setSamplingPeriod(1.0);
  tmp1->DoubleSignal::copySamplesFrom(newVector);
  tmp1->multiply(1e3);
  Signal * tmp2=new Signal(GeopsyCoreEngine::instance()->defaultDatabase());
  tmp2->setNSamples(mainVector->nSamples());
  tmp2->DoubleSignal::copySamplesFrom(mainVector);
  tmp2->setSamplingPeriod(1.0);
  tmp2->multiply(1e3);
  Signal * tmp3=new Signal(GeopsyCoreEngine::instance()->defaultDatabase());
  tmp3->setNSamples(corr->nSamples());
  tmp3->DoubleSignal::copySamplesFrom(corr);
  tmp3->setSamplingPeriod(1.0);
  tmp3->multiply(1e3);
  SubSignalPool pool;
  pool.addSignal(tmp1);
  //App::log(tmp1->nSamples() << Qt::endl;
  pool.addSignal(tmp2);
  //App::log(tmp2->nSamples() << Qt::endl;
  pool.addSignal(tmp3);
  //App::log(tmp3->nSamples() << Qt::endl;
  pool.save("gpmaplayer_debug_corr", false, SignalFileFormat::Gse2);
  App::log(tr("Working signals saved in gpmaplayer_debug_corr\n") );
}
