/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SHAMPLIFICATIONTHREAD_H
#define SHAMPLIFICATIONTHREAD_H

#include "Seismic1DThread.h"

class ShAmplificationThread : public Seismic1DThread
{
public:
  ShAmplificationThread(QObject * parent);
  ShAmplificationThread(const ShAmplificationThread& o);
  ~ShAmplificationThread();

  ResultsThread * clone() const {return new ShAmplificationThread(*this);}

  void initResultsGraphs(GraphicSheet * sheet);
  void initResultsGraphs(const ResultsThread& o) {CurvesThread::initResultsGraphs(o);}
  bool setParameters(int& argc, char ** argv);
private:
  virtual void run(GeophysicalModel * m);
};

#endif // SHAMPLIFICATIONTHREAD_H
