/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-04
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RESULTS_H
#define RESULTS_H

#include <QGpCoreWave.h>
#include <SciFigs.h>

class ResultsThread;

class Results : public GraphicSheet
{
  Q_OBJECT
public:
  Results(QWidget * parent=nullptr);
  ~Results();

  enum CurveType {Dispersion, DispersionGrid, Ellipticity, ShAmplification, MagnetoTelluric};

  bool setCurveType(CurveType curveType, int& argc, char ** argv);

  GeophysicalModel * createModel() const;
  void setForeground(GeophysicalModel * m);
  void addBackground(GeophysicalModel * m);
  void calculateBackground();
  void clearBackground();
  ResultsThread * calculator() const {return _foregroundThread;}
public slots:
  void setAutomaticLimits(bool a);
private:
  void calculate(ResultsThread * t, QList<GeophysicalModel *> models);

  bool _automaticLimits;

  QList<GeophysicalModel *> _backgroundModels;

  ResultsThread * _backgroundThread;
  ResultsThread * _foregroundThread;
};

#endif // RESULTS_H
