/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-17
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVESTHREAD_H
#define CURVESTHREAD_H

#include <SciFigs.h>

#include "ResultsThread.h"

class CurvesThread : public ResultsThread
{
  Q_OBJECT
public:
  CurvesThread(QObject * parent=nullptr);
  CurvesThread(const CurvesThread& o);
  ~CurvesThread();

  void initResultsGraphs(GraphicSheet * sheet);
  void initResultsGraphs(const ResultsThread& o);
  bool setParameters(int& argc, char ** argv);

  void clear();
  void resultsDeepUpdate();
  void setResultsLimits();

  double minX() const {return _x[0];}
  double maxX() const {return _x[_x.count()-1];}
  const QList< Curve<Point2D> >& curves() const {return _curves;}
  void run(GeophysicalModel * model)=0;
  virtual LegendWidget * legend() const=0;
private slots:
  virtual void showCurves();
protected:
  virtual void run();

  VectorList<double> _x;

  QList< Curve<Point2D> > _curves;
  LineLayer * _layer;
};

#endif // CURVESTHREAD_H
