/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CONTROLPANEL_H
#define CONTROLPANEL_H

#include <QWidget>

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>

#include "ui_ControlPanel.h"

class ModelSlider;

class ControlPanel : public QWidget, private Ui::ControlPanel, public XMLClass
{
  Q_OBJECT
public:
  ControlPanel(QWidget * parent=nullptr);
  ~ControlPanel();

  virtual const QString& xml_tagName() const {return xmlControlPanelTag;}
  static const QString xmlControlPanelTag;

  void setReferenceModel(GeophysicalModel * m);
  void clear();
  void load(QString fileName);
  ModelSlider * slider(QString sliderPattern);
private slots:
  void on_addSliderBut_clicked();
  void on_loadBut_clicked();
  void on_saveBut_clicked();
signals:
  void modelChanged(GeophysicalModel * m);
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  GeophysicalModel * _referenceModel;
};

#endif // CONTROLPANEL_H
