/***************************************************************************
**
**  This file is part of gphistogram.
**
**  gphistogram is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gphistogram is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-08-21
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GAUSSIANMIXTUREOUTPUT_H
#define GAUSSIANMIXTUREOUTPUT_H

#include <QGpCoreStat.h>

class GaussianMixtureOutput : public QObject
{
  Q_OBJECT
public:
  GaussianMixtureOutput(QObject * parent=nullptr);
  ~GaussianMixtureOutput();

  void setHistogramInversion(HistogramInversion * d) {_inversion=d;}
  GaussianMixtureDistribution filter(int index) const;
public slots:
  void newValues(int index);
private:
  HistogramInversion * _inversion;
};

#endif // GAUSSIANMIXTUREOUTPUT_H

