/***************************************************************************
**
**  This file is part of gpgroup2phase.
**
**  gpgroup2phase is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgroup2phase is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GROUP2PHASEREADER_H
#define GROUP2PHASEREADER_H

#include <QGpCoreMath.h>

class Group2PhaseReader : public ArgumentStdinReader
{
  TRANSLATIONS("Group2PhaseReader")
public:
  Group2PhaseReader();

  bool setOptions(int& argc, char ** argv);
protected:
  virtual bool parse(QTextStream& s);
private:
  void scanCurve(Curve<Point2D>& groupCurve);
  Curve<Point2D> phase(const Curve<Point2D>& groupCurve, double s1, double s2);
  Curve<Point2D> group(const Curve<Point2D>& phaseCurve);

  enum Mode {Group2Phase, Phase2Group};
  Mode _mode;
  QString _comments;
};

#endif // GROUP2PHASEREADER_H
