/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-03-03
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMETERS_H
#define PARAMETERS_H

#include <ArrayCore.h>

class Parameters : public FKParameters
{
public:
  Parameters();

  void setVerticalNoise(double n) {_verticalNoise=n;}
  double verticalNoise() const {return _verticalNoise;}

  void setHorizontalNoise(double n) {_horizontalNoise=n;}
  double horizontalNoise() const {return _horizontalNoise;}
private:
  double _verticalNoise, _horizontalNoise;
};

#endif // PARAMETERS_H

