/***************************************************************************
**
**  This file is part of gpell.
**
**  gpell is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpell is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPTICITYREADER_H
#define ELLIPTICITYREADER_H

#include <QGpCoreMath.h>

class EllipticityReader : public ArgumentStdinReader
{
  TRANSLATIONS("EllipticityReader")
public:
  EllipticityReader();

  bool setOptions(int& argc, char ** argv);
  bool modelLessAction();
protected:
  virtual bool parse(QTextStream& s);
private:
  enum AppMode {CurveMode, HalfSpace};
  AppMode _mode;

  int _nRayleigh;

  SamplingParameters _sampling;

  bool _outputCurves;
  bool _calculatePeaks;
  bool _abs;
  bool _angleDeg;
  bool _angleRad;
  bool _oneMode;
  double _signThreshold;
  double _love;
  bool _plot;
  bool _ignoreErrors;
  double _vp, _vs, _qp, _qs;
  double _precision;

  VectorList<double> _x;
};

#endif // ELLIPTICITYREADER_H
