/***************************************************************************
**
**  This file is part of gpec8.
**
**  gpec8 is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpec8 is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "EC8Reader.h"

/*!
  \class EC8Reader EC8Reader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
EC8Reader::EC8Reader()
    : ArgumentStdinReader()
{
}

bool EC8Reader::setOptions(int& argc, char ** argv)
{
  TRACE;
  // Check arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      App::log(tr("gpec8: bad option %1, see -help\n").arg(argv[i]) );
      return false;
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  return true;
}

bool EC8Reader::parse(QTextStream& s)
{
  TRACE;
  QTextStream sOut(stdout);
  Seismic1DModel m;
  QString comments;
  if(!m.fromStream(s, &comments)) {
    return false;
  }
  if(m.layerCount()>0) {
    sOut << comments;
    // Get Vs averaged over the first 30 m
    VectorList<double> sampling;
    sampling << 5.0;
    sampling << 30.0;
    Profile p=m.vsProfile();
    p.inverse();
    p.resample(sampling);
    p.average();
    p.setSamples(sampling);
    p.inverse();
    double vs5=p.values()[0];
    double vs30=p.values()[1];
    sOut << "Vs30 " << vs30;

    // Test for class S1: at least 10 m with a velocity <= 100 m/s over the first 30 m
    double startLvzDepth=-1.0;
    for(double d=0.0; d<30.0; d+=0.5) {
      if(m.vsAt(d)<=100.0) {
        if(startLvzDepth<0) startLvzDepth=0;
      } else if(startLvzDepth>=0) {
        if(d-startLvzDepth>=10.0) {
          if(vs30<=100.0) {
            sOut << " Class S1\n";
          } else {
            sOut << " Class S1?\n";
          }
          return true;
        }
        startLvzDepth=-1.0;
      }
    }

    // Test for class E: thickness of 5-20 m with a velocity < 360 and next velocity > 800 m/s
    startLvzDepth=-1.0;
    for(double d=0.0; d<30.0; d+=0.5) {
      if(m.vsAt(d)<=360.0) {
        if(startLvzDepth<0) startLvzDepth=0;
      } else if(startLvzDepth>=0.0 && m.vsAt(d)>=800.0){
        double h=d-startLvzDepth;
        if(h>=5.0 && h<=20.0) {
          sOut << " Class E\n" << Qt::endl;
          return true;
        } else {
          break;
        }
      } else {
        startLvzDepth=-1.0;
      }
    }

    // Other class identification
    if(vs30>=800.0 && vs5>=360.0) { // max thickness of weaker materials=5m
      sOut << " Class A\n";
    } else if(vs30>360.0) {
      sOut << " Class B\n";
    } else if(vs30>=180.0) {
      sOut << " Class C\n";
    } else if(vs30<=100.0) {
      sOut << " Class S1\n";
    } else {
      sOut << " Class D\n";
    }
  }
  return true;
}
