/***************************************************************************
**
**  This file is part of gpdepths.
**
**  gpdepths is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpdepths is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-02-02
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DEPTHDISTRIBUTION_H
#define DEPTHDISTRIBUTION_H

#include <QtCore>

#include <QGpCoreTools.h>

class DepthDistribution
{
  TRANSLATIONS("DepthDistribution")
public:
  DepthDistribution();

  void setMinimumWavelength(double m);
  double minimumWavelength() const {return _minimumWavelength;}

  void setMaximumWavelength(double m) {_maximumWavelength=m;}
  double maximumWavelength() const {return _maximumWavelength;}

  bool setLayerCount(int layerCount);
  int layerCount() const {return _n;}

  bool calculate();
  double y(double q) const;
  double derivative(double q) const;
  double a() const {return _a;}
  double q() const {return _q;}

  double minimumDepth(int i) const;
  double maximumDepth(int i) const;
  double thickness(int i) const;
  void report(QTextStream& s) const;
private:
  int _n;
  double _minimumWavelength;
  double _maximumWavelength;
  double _a, _q;
  VectorList<double> _depths;
};

#endif // DEPTHDISTRIBUTION_H
