/***************************************************************************
**
**  This file is part of geopsyrefra.
**
**  geopsyrefra is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyrefra is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ToolRefra_H
#define ToolRefra_H

#include <GeopsyGui.h>

class ToolRefrad;

class ToolRefra :  public AbstractToolWidget
{
  Q_OBJECT
public:
  ToolRefra(QWidget * parent);
  ~ToolRefra();

  virtual bool initStations(SubSignalPool *);
public slots:
  void startInversion();
protected:
  virtual void updateAllFields();
  ToolRefrad * _d;
  int _nSrc; // 
  QList<double> _distances; // list of node abscissae
  QList<double> _srcDist; // list of distances for source nodes
  QMap<double, Signal *> * _distSigMaps; // for each source, abscissae<-->signal
};

#endif
