/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-17
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "SpectrumToolWidget.h"
#include "SpectrumStation.h"
#include "SpectrumResultSheet.h"
#include "SpectrumSummary.h"

/*!
  \class SpectrumToolWidget SpectrumToolWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SpectrumToolWidget::SpectrumToolWidget(QWidget * parent)
    : AbstractHVWidget(parent)
{
  TRACE;
  setWindowIcon(QIcon(":spectrum-22x22.png"));
  setObjectName("SpectrumToolWidget");

  winParam->addComponent(tr("Any component"));

  removeHorizontalComponents();
  removeRotateStep();

  _tool=new SpectrumTool(this);
}

bool SpectrumToolWidget::setSubPool(SubSignalPool * subPool)
{
  TRACE;
  if(!AbstractHVWidget::setSubPool(subPool)) {
    return false;
  }
  if(_winResults) {
    _winResults->setUnits(tr("Power spectral density [(%1)^2/Hz]"));
    if(_summary) {
      _summary->setValueTitle(_winResults->valueTitle());
    }
  }
  setWindowTitle(tr("Spectrum toolbox - ")+subPool->name());
  return true;
}

AbstractResultSheet * SpectrumToolWidget::createResultSheet()
{
  TRACE;
  SpectrumResultSheet * w=new SpectrumResultSheet;
  connect(w, SIGNAL(peakChanged()), this, SLOT(updateSummary()));
  return w;
}

AbstractSummary * SpectrumToolWidget::createSummary()
{
  TRACE;
  return new SpectrumSummary;
}
