/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-03-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WAVEFORMCONSOLE_H
#define WAVEFORMCONSOLE_H

#include <GeopsyGui.h>

#include "ui_WaveformConsole.h"

class WaveformConsole : public QWidget, private Ui::WaveformConsole
{
  Q_OBJECT
public:
  WaveformConsole(QWidget * parent=0, Qt::WindowFlags f=Qt::Widget);
  ~WaveformConsole();

  void setCurrentSubPool(SubPoolWindow * w);
  SubPoolWindow * currentSubPool() const {return _subPoolWin;}

  void addActions(QMenu * m);
public slots:
  void removeTrend();
  void subtractValue();
  void addSignals();
  void subtractSignals();
  void multiply();
  void filter();
  void agc();
  void whiten();
  void stddevClip();
  void shift();
  void overSample();
  void taper();
  void cut();
  void merge();
  void decimateAmplitude();
  void decimateTime();
  void random();
  void waveletTransform();
  void stalta();
  void rotate();
  void correlations();
  void normalizedCorrelations();
  void convolution();
  void removeInstrumentalResponse();
  void revert();
private slots:
  void on_runBut_clicked();
  void on_helpBut_clicked();
  void restoreStep();
private:
  void processUpdate();
  void setSteps(const QStringList& steps);

  SubPoolWindow * _subPoolWin;
};

#endif // WAVEFORMCONSOLE_H
