/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-10-02
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include "SubtractGroupItem.h"

/*!
  \class SubtractGroupItem SubtractGroupItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SubtractGroupItem::SubtractGroupItem(int nSignals, QObject * parent)
  :  SignalGroupItem(parent)
{
  TRACE;
   _nSignals=nSignals;
}

/*!
  Check if group have the correct number of signals
*/
Qt::ItemFlags SubtractGroupItem::flags (const QModelIndex & index) const
{
  const AbstractSignalGroup * g=group(index);
  if(g->signalCount()==_nSignals)
    return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
  else
    return Qt::NoItemFlags;
}
