/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-19
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SOURCECOORDINATES_H
#define SOURCECOORDINATES_H

#include <QComboBox>

#include <GeopsyCore.h>
#include <QGpCoreTools.h>
#include "StationCoordinates.h"

class SourceCoordinates : public StationCoordinates
{
  Q_OBJECT
public:
  SourceCoordinates(QWidget * parent=nullptr);

  QString sourceNamePattern() const;
  bool init(SubSignalPool * subPool);
  bool initLookup();
protected:
  virtual QString keyName(Signal * sig);
  virtual Point coordinates(Signal * sig) {return sig->source();}
private slots:
  void on_applyBut_clicked();
  void on_sourceNameEdit_editTextChanged(const QString& text);
private:
  QComboBox * sourceNameEdit;
  QPushButton * applyBut;
  ExpressionString _keyExpression;
  SignalExpressionContext _keyExpressionContext;
  SubSignalPool * _subPool;
};

#endif // SOURCECOORDINATES_H
