/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>

#include "SortKeysDelegate.h"
#include "SortKeysModel.h"

/*!
  \class SortKeysDelegate SortKeysDelegate.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SortKeysDelegate::SortKeysDelegate(QObject * parent)
    : ItemDelegate(parent)
{
  TRACE;
  _keyList=MetaDataFactory::instance()->registeredNames();
}

QWidget *SortKeysDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &,
                                     const QModelIndex &index) const
{
  switch(index.column()) {
  case 0: {
      QComboBox * w=createComboBox(parent);
      w->addItems(_keyList);
      return w;
    }
  case 1:
    return createLineEdit(parent);
  case 2: {
      QComboBox *w=createComboBox(parent);
      w->addItem(SortKeysModel::ascending);
      w->addItem(SortKeysModel::descending);
      return w;
    }
  default:
    break;
  }
  return nullptr;
}
