/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-05-04
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SignalTableDelegate.h"
#include "SignalTableItem.h"

QWidget * SignalTableDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem&,
                                            const QModelIndex& index) const
{
  TRACE;
  const SignalTableItem * tableItem=qobject_cast<const SignalTableItem *>(index.model());
  ASSERT(tableItem);

  MetaDataIndex i=tableItem->dataIndex(index.column());
  bool readOnly=MetaDataFactory::instance()->isReadOnly(i);
  switch (i.id()) {
  case MetaDataFactory::Component: {
      QComboBox * w=createComboBox(parent);
      w->addItem(tr("Vertical"));
      w->addItem(tr("North"));
      w->addItem(tr("East"));
      w->addItem(tr("Horizontal"));
      w->addItem(tr("All"));
      w->addItem(tr("Undefined"));
      w->setEnabled(!readOnly);
      return w;
    }
  case MetaDataFactory::AmplitudeUnit: {
      QComboBox * w=createComboBox(parent);
      w->addItem(tr("Displacement"));
      w->addItem(tr("Velocity"));
      w->addItem(tr("Acceleration"));
      w->addItem(tr("Custom"));
      w->setEnabled(!readOnly);
      return w;
    }
  default: {
      if(i.id()==Comments::staticId()) {
        QPlainTextEdit * w=new QPlainTextEdit(parent);
        w->setReadOnly(readOnly);
        return w;
      } else {
        QLineEdit * w=createLineEdit(parent);
        w->setReadOnly(readOnly);
        return w;
      }
    }
  }
}
