/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <GeopsyGui.h>

#include "ui_Preferences.h"
#include "ViewParamEditor.h"

class ViewParamEditor;

class Preferences : public Dialog, public Ui::Preferences
{
  Q_OBJECT
public:
  Preferences(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags());
  ~Preferences();

  void saveToolList();
public slots:
  void updateAll();
  void on_formatFixed_toggled();
  void on_formatCustomAscii_clicked();
  void on_winDoIt_toggled();

  void on_fileDefaults_clicked();
  void on_poolDefaults_clicked();
  void on_searchTool_clicked();
  void on_addSep_clicked();
  void on_removeTool_clicked();
  void on_moveToolUp_clicked();
  void on_moveToolDown_clicked();
  void on_addPath_clicked();
  void on_removePath_clicked();
  void on_cacheSwapDirBut_clicked();

  void on_graphicMakeUpSwitch_toggled();
  void on_graphicMakeUpBrowse_clicked();
  void on_mapMakeUpSwitch_toggled();
  void on_mapMakeUpBrowse_clicked();
  void on_chronogramMakeUpSwitch_toggled();
  void on_chronogramMakeUpBrowse_clicked();
private:
  QStringList getPaths();
  QStringList getTools();
  void setPluginList(QStringList libs);
};

#endif // QTBDIALOG_PREFERENCES_H

