/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-11-10
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/
#ifndef GRAPHICWINDOW_H
#define GRAPHICWINDOW_H

#include <GeopsyGui.h>

class MagnifierSignal;

class GraphicWindow: public AbstractGraphicWindow
{
  Q_OBJECT
public:
  GraphicWindow(QWidget* parent=nullptr);
  ~GraphicWindow();

  virtual void setWindowTitle(QString title);
  virtual void subPoolUpdate();
  virtual void endSignalChange(Signal * sig=nullptr);
  virtual void fastFourierTransform(DoubleSignal::SignalType st);

  virtual SignalLayer * signalLayer() const {return _signalLayer;}
  virtual TimeWindowLayer * timeWindowLayer() const {return _timeWindowLayer;}
  virtual PickLayer * pickLayer() const {return _pickLayer;}

  void updateLabels();
  void updateEvents();
public slots:
  void getSelection(SubSignalPool& sel);
  void showMagnify(bool magnify, int context, double time, Signal * sig);
  void closeMagnify();
  void setMagnifyPosition(double x);
  void setMagnifySignal(Signal * sig);
protected:
  virtual void focusInEvent(QFocusEvent * e);

  SignalLayerControls * _controls;
  SignalLayer * _signalLayer;
  TimeWindowLayer * _timeWindowLayer;
  PickLayer * _pickLayer;
  SlopeEstimator * _slopeLayer;
 // Pointer to the window used to zoom in during picking, NULL if not in use
  MagnifierSignal * _magWin;
};

#endif /* GRAPHICWINDOW_H */
