/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TARGETLISTWIDGET_H
#define TARGETLISTWIDGET_H

#include <QtGui>

#include <QGpCoreWave.h>
#include <DinverDCCore.h>

#include "ui_TargetListWidget.h"

class ParamGroundModelWidget;
class DispersionTargetWidget;
class EllipticityCurveTargetWidget;
class EllipticityPeakTargetWidget;
class AutocorrTargetWidget;
class RefractionTargetWidget;
class MagnetoTelluricTargetWidget;

class TargetListWidget : public QWidget, public Ui::TargetListWidget
{
  Q_OBJECT
public:
  TargetListWidget(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

  TargetList * targetList();
  void clear();
  void setTitles(const QString& name);
public slots:
  void on_dispSelect_toggled(bool);
  void on_autocorrSelect_toggled(bool);
  void on_ellCurveSelect_toggled(bool);
  void on_ellPeakSelect_toggled(bool);
  void on_refraVpSelect_toggled(bool);
  void on_refraVsSelect_toggled(bool);
  void on_magnetoTelluricSelect_toggled(bool);

  void on_dispSet_clicked();
  void on_autocorrSet_clicked();
  void on_ellCurveSet_clicked();
  void on_ellPeakSet_clicked();
  void on_refraVpSet_clicked();
  void on_refraVsSet_clicked();
  void on_magnetoTelluricSet_clicked();

  void updateInfo();
  void setParamProfiles(ParamGroundModelWidget * p);
  void setFrom(TargetList * tl);

  void setEditable(bool e);
signals:
  void targetChanged();
protected:
  // Target widgets
  DispersionTargetWidget * _dispWidget;
  EllipticityCurveTargetWidget * _ellCurveWidget;
  EllipticityPeakTargetWidget * _ellPeakWidget;
  AutocorrTargetWidget * _autocorrWidget;
  RefractionTargetWidget * _refraVpWidget;
  RefractionTargetWidget * _refraVsWidget;
  MagnetoTelluricTargetWidget * _magnetoTelluricWidget;
};

#endif // QTBTARGETLISTWIDGET_H
