/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef THREADLAUNCHER_H
#define THREADLAUNCHER_H

#include <QQueue>

#include "ui_ThreadLauncher.h"

class ThreadLauncher : public QWidget, public Ui::ThreadLauncher
{
  Q_OBJECT
public:
  ThreadLauncher(QWidget* parent=0);
  ~ThreadLauncher();

  QString processBaseName(QString str);
  int processNameRank(QString str);
  QString processCompleteName(QString str, int num);
  bool isAnySelected();
  bool isQueued() const {return !_processToStart.isEmpty();}
  bool assumeAllSelected(QString title, QString action);
  void wait();
public slots:
  void start();
  void stop();
  void clear();
  void show(bool s);
  void remove();
  void importModels();
  void dequeueAll() {_processToStart.clear();}
  InversionThread * newThread();
  void processFinished();
signals:
  void setCurrentRuns(ThreadList tList);
private slots:
  void selectionChanged();
private:
  void start(InversionThread * t);
  void startQueued();
  QQueue<InversionThread *> _processToStart;
  int _runningProcess;
};

#endif // QTBTHREADLAUNCHER_H
