/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-01
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAUNCHTHREADITEM_H
#define LAUNCHTHREADITEM_H

#include <QtCore>

class LaunchThreadItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  LaunchThreadItem(QObject * parent=nullptr);
  ~LaunchThreadItem();

  int rowCount(const QModelIndex& parent=QModelIndex()) const;
  int columnCount(const QModelIndex& parent=QModelIndex()) const;
  QVariant data(const QModelIndex& index, int role) const;
  QVariant headerData(int section, Qt::Orientation orientation, int role) const;
  QModelIndex index(int, int column, const QModelIndex&) const;
  bool setData(const QModelIndex& index, const QVariant& value, int role);
  Qt::ItemFlags flags(const QModelIndex&) const;
private slots:
  void beginClearThreads();
  void endClearThreads();
  void beginNewThread();
  void endNewThread();
  void beginRemoveThread(int index);
  void endRemoveThread();
};

#endif // LAUNCHTHREADITEM_H
