/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-01
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "LaunchThreadDelegate.h"
#include "InversionThread.h"
#include "WindowEnvironment.h"
#include "MainWindow.h"

QWidget * LaunchThreadDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                             const QModelIndex & index) const
{
  TRACE;
  switch (index.column()) {
  case 0: {
      InversionThread * t=WindowEnvironment::window(parent)->threads().at(index.row());
      if(!t->isRunning()) {
        return createLineEdit(parent);
      }
    }
    break;
  case 6: {
      QSpinBox * w=createSpinBox(parent);
      w->setSuffix( " %" );
      w->setMinimum(0);
      w->setMaximum(100);
      return w;
    }
  default: {
      QSpinBox * w=createSpinBox(parent);
      w->setMinimum(0);
      w->setMaximum(INT_MAX);
      return w;
    }
  }
  return nullptr;
}
