/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-01-26
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SHEETSELECTIONWIDGET_H
#define SHEETSELECTIONWIDGET_H

#include "SciFigsDLLExport.h"
#include "GraphicObject.h"
#include "GraphicObjectList.h"

namespace SciFigs {

  class SCIFIGS_EXPORT SheetSelectionWidget : public QWidget
  {
    Q_OBJECT
  public:
    SheetSelectionWidget(QWidget * parent=nullptr);
    ~SheetSelectionWidget();

    void addObject(GraphicObject * obj, GraphicObject::SelectionState );
    void removeObject(GraphicObject * obj);
    void clear(PropertyProxy * proxy=nullptr);

    const GraphicObjectList& list() const {return _objects;}
  protected:
    virtual void paintEvent(QPaintEvent * e);
  private:
    GraphicObjectList _objects;
  };

} // namespace SciFigs

#endif // SHEETSELECTIONWIDGET_H

