/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REALSTATISTICALLINE_H
#define REALSTATISTICALLINE_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT RealStatisticalLine : public AbstractLine
{
public:
  RealStatisticalLine() {}
  RealStatisticalLine(const RealStatisticalLine& o);

  AbstractLine * clone() const;
  void operator=(const RealStatisticalLine& o);
  bool canCopy(const AbstractLine& o) const;

  const QString& xml_tagName() const {return xmlRealStatisticalLineTag;}
  static const QString xmlRealStatisticalLineTag;

  int count() const {return _curve.count();}
  void clear() {_curve.clear();}
  void append() {_curve.append(RealStatisticalPoint());}
  void insert(int index) {_curve.insert(index, RealStatisticalPoint());}
  void removeLast() {_curve.remove(_curve.count()-1);}
  bool isValid(int index) const {return _curve.isValid(index);}
  void setValid(int index, bool v) {_curve.setValid(index, v);}
  bool isSorted() const {return _curve.isSorted();}
  void checkSort() {_curve.checkSort();}
  void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    return _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  Point point(int index, const CurvePointOptions *) const;
  void setX(int index, double v) {_curve.setX(index, v);}
  void setY(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setMean(v);}
  void setZ(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setStddev(v);}

  const RealStatisticalCurve& curve() const {return _curve;}
  RealStatisticalCurve& curve() {return _curve;}
  void setCurve(const RealStatisticalCurve& curve) {_curve=curve;}
protected:
  RealStatisticalCurve _curve;
};

} // namespace SciFigs

#endif // REALSTATISTICALLINE_H
