/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARALLELBAND_H
#define PARALLELBAND_H

#include "SciFigsDLLExport.h"
#include "Pen.h"
#include "Brush.h"

namespace SciFigs {

class SCIFIGS_EXPORT ParallelBand : public XMLClass
{
public:
  ParallelBand(const Brush& b=Qt::SolidPattern, const Pen& p=Pen::NoLine);
  ParallelBand(double value, const Pen& p=Pen::SolidLine);
  ParallelBand(double min, double max, const Brush& b=Qt::SolidPattern,
               const Pen& p=Pen::NoLine);
  virtual ~ParallelBand() {}

  virtual const QString& xml_tagName() const {return xmlParallelBandTag;}
  static const QString xmlParallelBandTag;

  void setValue(double v) {_minimum=v; _maximum=v;}
  double value() const {return _minimum;}

  void setMinimum(double m) {_minimum=m;}
  double minimum() const {return _minimum;}

  void setMaximum(double m) {_maximum=m;}
  double maximum() const {return _maximum;}

  void setPen(const Pen& p) {_pen=p;}
  const Pen& pen() const {return _pen;}

  void setBrush(const Brush& b) {_brush=b;}
  const Brush& brush() const {return _brush;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
protected:
  Pen _pen;
  Brush _brush;
  double _minimum, _maximum;
};

} // namespace SciFigs

#endif // PARALLELBAND_H
