/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-26
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "NameLineItem.h"
#include "NameLineLayer.h"
#include "LayerLocker.h"

namespace SciFigs {

/*!
  \class NameNameLineItem NameNameLineItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
NameLineItem::NameLineItem(QObject * parent)
   : QAbstractTableModel(parent)
{
  _layer=0;
}

void NameLineItem::setLayer(NameLineLayer * layer)
{
  TRACE;
  beginResetModel();
  _layer=layer;
  endResetModel();
}

int NameLineItem::rowCount(const QModelIndex &parent) const
{
  TRACE;
  if(!_layer) return 0;
  if( !parent.isValid())
    return _layer->count();
  return 0;
}

int NameLineItem::columnCount(const QModelIndex & ) const
{
  TRACE;
  return 3;
}

QVariant NameLineItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  if(!_layer) return QVariant();
  if( !index.isValid()) return QVariant();
  switch (role) {
  case Qt::DisplayRole: {
      const AbstractNameLine * l=_layer->line(index.row());
      switch(index.column()) {
      case 0: return l->textDx();
      case 1: return l->textDy();
      case 2: return l->textOrientation();
      default: return QVariant();
      }
    }
  default:
    return QVariant();
  }
}

bool NameLineItem::setData (const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  if(!_layer) return false;
  if( !index.isValid()) return false;
  switch (role) {
  case Qt::EditRole: {
      LayerLocker ll(_layer);
      AbstractNameLine * l=_layer->line(index.row());
      switch(index.column()) {
      case 0: l->setTextDx(value.toDouble()); break;
      case 1: l->setTextDy(value.toDouble()); break;
      case 2: l->setTextOrientation(value.toDouble()); break;
      default: break;
      }
      _layer->deepUpdate();
      emit dataChanged(index, index);
      return true;
    }
  default:
    return false;
  }
}

QVariant NameLineItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    switch (section) {
    case 0: return tr("Label Dx");
    case 1: return tr("Label Dy");
    case 2: return tr("Orientation");
    default: return 0;
    }
  } else {
    return section + 1;
  }
}

Qt::ItemFlags NameLineItem::flags (const QModelIndex &) const
{
  if(!_layer) {
    return Qt::NoItemFlags;
  }
  return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;
}

} // namespace SciFigs
