/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-25
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MakeUpFilter.h"

namespace SciFigs {

/*!
  \class MakeUpFilter MakeUpFilter.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MakeUpFilter::MakeUpFilter(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
  Settings::columnWidth(xmlEditor, "MakeUpFilter::xmlEditor");
  Settings::getWidget(this);
  _expandedHeight=height();
}

/*!
  Description of destructor still missing
*/
MakeUpFilter::~MakeUpFilter()
{
  TRACE;
  Settings::setColumnWidth(xmlEditor, "MakeUpFilter::xmlEditor");
  Settings::setWidget(this);
}

void MakeUpFilter::on_customFilter_toggled()
{
  TRACE;
  xmlEditor->setVisible(customFilter->isChecked());
  QApplication::processEvents();
  if(customFilter->isChecked()) {
    resize(width(), _expandedHeight);
  } else {
    _expandedHeight=height();
    QSize s=QSize().expandedTo(minimumSizeHint());
    resize(width(), s.height());
  }
}

void MakeUpFilter::updateFields()
{
  TRACE;
  on_customFilter_toggled();
  on_printX_toggled();
  on_printY_toggled();
  on_titleX_toggled();
  on_titleY_toggled();
  on_rangeX_toggled();
  on_rangeY_toggled();
  on_layers_toggled();
}

void MakeUpFilter::setXml(QString xml)
{
  TRACE;
  xmlEditor->model()->setText(xml);
  xmlEditor->expandAll();
  updateFields();
}

QString MakeUpFilter::saveString() const
{
  TRACE;
  return xmlEditor->model()->saveString();
}

QByteArray MakeUpFilter::saveByteArray() const
{
  TRACE;
  return xmlEditor->model()->saveByteArray();
}

void MakeUpFilter::saveFile(QString fileName) const
{
  TRACE;
  xmlEditor->model()->saveFile(fileName);
}

void MakeUpFilter::on_printX_toggled()
{
  TRACE;
  xmlEditor->setAxisWindowProperty(printX->isChecked(), "printX" );
}

void MakeUpFilter::on_printY_toggled()
{
  TRACE;
  xmlEditor->setAxisWindowProperty(printY->isChecked(), "printY" );
}

void MakeUpFilter::on_titleX_toggled()
{
  TRACE;
  xmlEditor->setAxisProperty(titleX->isChecked(), "title", true);
  xmlEditor->setAxisProperty(titleX->isChecked(), "inverseTitle", true);
}

void MakeUpFilter::on_titleY_toggled()
{
  TRACE;
  xmlEditor->setAxisProperty(titleY->isChecked(), "title", false);
  xmlEditor->setAxisProperty(titleY->isChecked(), "inverseTitle", false);
}

void MakeUpFilter::on_rangeX_toggled()
{
  TRACE;
  xmlEditor->setAxisProperty(rangeX->isChecked(), "min", true);
  xmlEditor->setAxisProperty(rangeX->isChecked(), "max", true);
}

void MakeUpFilter::on_rangeY_toggled()
{
  TRACE;
  xmlEditor->setAxisProperty(rangeY->isChecked(), "min", false);
  xmlEditor->setAxisProperty(rangeY->isChecked(), "max", false);
}

void MakeUpFilter::on_layers_toggled()
{
  TRACE;
  xmlEditor->setLayers(layers->isChecked());
}

} // namespace SciFigs
