/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-28
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef LAYERPICKER_H
#define LAYERPICKER_H

#include "SciFigsDLLExport.h"
#include "GraphContentsLayer.h"

namespace SciFigs {

  class SCIFIGS_EXPORT LayerPicker : public QObject
  {
    Q_OBJECT
  public:
    LayerPicker(QObject * parent);
    ~LayerPicker();

    bool eventFilter(QObject *, QEvent * event);
    void addLayer(GraphContentsLayer * layer);
    const QList<GraphContentsLayer *>& layers() {return _layers;}

    void begin(QWidget * w, const QCursor& cursor);
    void end(QWidget * w);
  protected:
    virtual void pick(GraphContentsLayer * layer, const QPointF& pos);
    virtual void finish();
  signals:
    void picked(const Point2D& p);
    void finished();
  private:
    void pick(const QPointF& pos);
    void track(const QPointF& pos);
    void wheel(QWheelEvent * e);

    QList<GraphContentsLayer *> _layers;
  };

} // namespace SciFigs

#endif // LAYERPICKER_H

