/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-28
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "LayerPicker.h"
#include "GraphContents.h"
#include "AxisWindow.h"

namespace SciFigs {

  /*!
    \class LayerPicker LayerPicker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  LayerPicker::LayerPicker(QObject * parent)
    : QObject(parent)
  {
    TRACE;
  }

  /*!
    Description of destructor still missing
  */
  LayerPicker::~LayerPicker()
  {
    TRACE;
  }

  void LayerPicker::addLayer(GraphContentsLayer * layer)
  {
    TRACE;
    _layers.append(layer);
  }

  void LayerPicker::begin(QWidget * w, const QCursor& cursor)
  {
    TRACE;
    w->setCursor(cursor);
    w->grabMouse();
    QGuiApplication::instance()->installEventFilter(this);
  }

  void LayerPicker::end(QWidget * w)
  {
    TRACE;
    w->setCursor(QCursor(Qt::ArrowCursor));
    w->releaseMouse();
    QGuiApplication::instance()->removeEventFilter(this);
  }

  bool LayerPicker::eventFilter(QObject *, QEvent * e)
  {
    TRACE;
    switch (e->type()) {
    case QEvent::MouseButtonRelease:
#if(QT_VERSION>=QT_VERSION_CHECK(6, 0, 0))
      pick(static_cast<QMouseEvent *>(e)->globalPosition());
#else
      pick(static_cast<QMouseEvent *>(e)->globalPos());
#endif
      return true;
    case QEvent::Wheel:
      wheel(static_cast<QWheelEvent *>(e));
      return true;
    case QEvent::MouseMove:
#if(QT_VERSION>=QT_VERSION_CHECK(6, 0, 0))
      track(static_cast<QMouseEvent *>(e)->globalPosition());
#else
      track(static_cast<QMouseEvent *>(e)->globalPos());
#endif
      return true;
    case QEvent::KeyPress:
      if(static_cast<QKeyEvent *>(e)->key()==Qt::Key_Escape) {
        finish();
      }
      return true;
    default:
      return false;
    }
  }

  void LayerPicker::pick(const QPointF& pos)
  {
    TRACE;
    for(int i=_layers.count()-1; i>=0; i--) {
      GraphContentsLayer * layer=_layers.at(i);
      GraphContents * gc=layer->graphContents();
#if(QT_VERSION>=QT_VERSION_CHECK(6, 0, 0))
      QPointF layerPos=gc->mapFromGlobal(pos);
#else
      QPointF layerPos=gc->mapFromGlobal(pos.toPoint());
#endif
      if(gc->visibleRegion().contains(layerPos.toPoint())) {
        pick(layer, layerPos);
        break;
      }
    }
    finish();
  }

  void LayerPicker::track(const QPointF& pos)
  {
    TRACE;
    for(int i=_layers.count()-1; i>=0; i--) {
      GraphContentsLayer * layer=_layers.at(i);
      GraphContents * gc=layer->graphContents();
#if(QT_VERSION>=QT_VERSION_CHECK(6, 0, 0))
      QPointF layerPos=gc->mapFromGlobal(pos);
#else
      QPointF layerPos=gc->mapFromGlobal(pos.toPoint());
#endif
      if(gc->visibleRegion().contains(layerPos.toPoint())) {
        AxisWindow * w=gc->graph();
        w->xAxis()->trackMouse(layerPos.toPoint());
        w->xAxis()->setMouseTrack(true);
        w->yAxis()->trackMouse(layerPos.toPoint());
        w->yAxis()->setMouseTrack(true);
        break;
      }
    }
  }

  void LayerPicker::wheel(QWheelEvent * e)
  {
    TRACE;
#if(QT_VERSION >= QT_VERSION_CHECK(5, 14, 0))
    QPoint pos=e->globalPosition().toPoint();
#else
    QPoint pos=e->globalPos();
#endif
    for(int i=_layers.count()-1; i>=0; i--) {
      GraphContentsLayer * layer=_layers.at(i);
      GraphContents * gc=layer->graphContents();
      QPoint layerPos=gc->mapFromGlobal(pos);
      if(gc->visibleRegion().contains(layerPos)) {
#if(QT_VERSION >= QT_VERSION_CHECK(5, 14, 0))
        QWheelEvent we(layerPos, QPointF(), QPoint(), e->angleDelta(), e->buttons(), e->modifiers(),
                       Qt::NoScrollPhase, false, Qt::MouseEventSynthesizedByQt);
        gc->wheelEvent(&we);
#else
        App::log(tr("Wheel event not forwarded to GraphContents for Qt<5.14\n"));
#endif
        break;
      }
    }
  }

  void LayerPicker::pick(GraphContentsLayer * layer, const QPointF& pos)
  {
    TRACE;
    const GraphContentsOptions& gc=layer->graphContents()->options();
    emit picked(gc.s2r(pos));
  }

  void LayerPicker::finish()
  {
    TRACE;
    emit finished();
  }


} // namespace SciFigs

