/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LayerPainterThread.h"
#include "LayerPainter.h"
#include "GraphContents.h"

namespace SciFigs {

/*!
  \class LayerPainterThread LayerPainterThread.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

LayerPainterThread::LayerPainterThread(LayerPainter * parent)
  : Thread(parent), _parent(parent)
{
  _terminate=false;
  _currentRequest=nullptr;
}

void LayerPainterThread::terminate()
{
  _terminate.fetchAndStoreOrdered(true);
  _parent->_queueMutex.lock();
  if(_currentRequest) _currentRequest->terminate();
  _parent->_queueMutex.unlock();
}

void LayerPainterThread::run()
{
  // CRASH: segmentation fault reported under windows Vista while closing Figue
  TRACE;
  while(true) {
    while(true) {
      if(_terminate.testAndSetOrdered(true, true)) {
        return;
      }
      // Check for new layers to paint, if nothing to do, the thread goes in sleep mode
      _parent->_queueMutex.lock();
      if(_parent->_queue.isEmpty()) {
        _parent->_queueMutex.unlock();
        break;
      }
      _currentRequest=_parent->_queue.dequeue();
      _parent->_queueMutex.unlock();
      //printf("%s: start painting %p\n",objectName().toLatin1().data(), _currentRequest->graphContents());
      _currentRequest->paint();
      //printf("%s: stop painting %p\n",objectName().toLatin1().data(), _currentRequest->graphContents());
      LayerPainterRequest * r=_currentRequest;
      _parent->_queueMutex.lock();
      _currentRequest=nullptr;
      _parent->_queueMutex.unlock();
      r->deleteLater();
    }
    _parent->_waitMutex.lock();
    //printf("%s: sleeping\n",objectName().toLatin1().data());
    _parent->_paintEvent.wait(&_parent->_waitMutex);
    //printf("%s: waking up\n",objectName().toLatin1().data());
    _parent->_waitMutex.unlock();
  }
}

} // namespace SciFigs
